<?php
include_once '../baseInfo.php';
include_once '../config.php';

$now = time();
$limit = 500;

// حذف مکانیزم OFFSET قدیمی
@unlink('warnOffset.txt');

// ===== helper =====
function normalizeTs($ts) {
    if ($ts === null || $ts === '' || !is_numeric($ts)) return null;
    $ts = (int)$ts;
    if ($ts > 2000000000) $ts = intdiv($ts, 1000); // ms -> s
    return ($ts > 0) ? $ts : null;
}

// ====== LOOP 1: پردازش سفارش‌هایی که باید الان بررسی شوند ======
// notif = 0 (هنوز هشدار نگرفته) یا notif < now (نوبت پردازش)
$stmt = $connection->prepare("
    SELECT * FROM `orders_list`
    WHERE `status`=1 AND (`notif`=0 OR `notif` < ?)
    ORDER BY
      (notif = 0) DESC,            -- اول اونهایی که هنوز هشدار نگرفتن
      CASE WHEN notif=0 THEN 0 ELSE notif END ASC,
      id ASC
    LIMIT ?
");
$stmt->bind_param("ii", $now, $limit);
$stmt->execute();
$orders = $stmt->get_result();
$stmt->close();

if ($orders && $orders->num_rows > 0) {
  while ($order = $orders->fetch_assoc()) {
    $from_id    = $order['userid'];
    $remark     = $order['remark'];
    $uuid       = $order['uuid'] ?? "0";
    $server_id  = (int)$order['server_id'];
    $inbound_id = (int)$order['inbound_id'];
    $notif      = (int)$order['notif'];

    // خواندن تنظیمات سرور
    $stmt = $connection->prepare("SELECT * FROM `server_config` WHERE `id`=?");
    $stmt->bind_param('i', $server_id);
    $stmt->execute();
    $serverConfig = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    $serverType = $serverConfig['type'] ?? '';
    // $panel_url = $serverConfig['panel_url'] ?? '';

    $found=false; $logedIn=false;
    $total=null; $up=0; $down=0; $enable=true; $expiryTime=null;

    if ($serverType === "marzban") {
        // اگر بعداً خواستی فعال کن، فعلاً تمرکز روی x-ui
        $info = getMarzbanUser($server_id, $remark);
        if (isset($info->username)) {
            $found   = true;
            $logedIn = true;
            $total   = $info->data_limit ?? null;
            $totalLeft = ($total !== null) ? ($total - ($info->used_traffic ?? 0)) : null;
            $expiryTime = $info->expire ?? null;
            $enable = (($info->status ?? '') === "active");
        } elseif (isset($info->detail) && $info->detail === "User not found") {
            $logedIn = true;
        }
    } else {
        // x-ui / sanaei
        $response = getJson($server_id);
        if ($response && $response->success) {
            $logedIn = true;
            $response = $response->obj;
            foreach ($response as $row) {
                if ($inbound_id == 0) {
                    // جست‌وجوی همه‌ی کلاینت‌ها (نه فقط clients[0])
                    $clients = [];
                    $settingsObj = json_decode($row->settings ?? '{}');
                    if (isset($settingsObj->clients) && is_array($settingsObj->clients)) {
                        $clients = $settingsObj->clients;
                    }
                    foreach ($clients as $c) {
                        $cid = $c->id ?? null;
                        $cpw = $c->password ?? null;
                        if (($cid && $cid == $uuid) || ($cpw && $cpw == $uuid)) {
                            $found = true;
                            $total = isset($row->total) ? (int)$row->total : null;
                            $up    = isset($row->up) ? (int)$row->up : 0;
                            $down  = isset($row->down) ? (int)$row->down : 0;
                            $expiryTime = $row->expiryTime ?? null; // ممکنه ms باشد
                            $enable = isset($row->enable) ? (bool)$row->enable : true;
                            break 2;
                        }
                    }
                } else {
                    if ((int)$row->id === $inbound_id) {
                        $settings = json_decode($row->settings ?? '[]', true);
                        $clients  = $settings['clients'] ?? [];
                        $clientsStates = $row->clientStats ?? [];
                        // map states by email
                        $statesByEmail = [];
                        foreach ($clientsStates as $st) {
                            $statesByEmail[$st->email ?? ''] = $st;
                        }
                        foreach ($clients as $client) {
                            $cid = $client['id'] ?? null;
                            $cpw = $client['password'] ?? null;
                            if (($cid && $cid == $uuid) || ($cpw && $cpw == $uuid)) {
                                $found = true;
                                $email = $client['email'] ?? '';
                                $st = $statesByEmail[$email] ?? null;
                                $total = isset($client['totalGB']) ? (int)$client['totalGB'] : null;
                                $up    = isset($st->up) ? (int)$st->up : 0;
                                $down  = isset($st->down) ? (int)$st->down : 0;
                                $enable = isset($st->enable) ? (bool)$st->enable : true;
                                $expiryTime = $st->expiryTime ?? null; // ممکنه ms باشد
                                break 2;
                            }
                        }
                    }
                }
            }
            // اگر از پنل چیزی نگرفتیم ولی در DB expire_date هست، بعنوان fallback
            if (!$expiryTime && !empty($order['expire_date'])) {
                $expiryTime = $order['expire_date'];
            }
            $expiryTimeSec = normalizeTs($expiryTime);

            // محاسبه‌ی مانده‌ی حجم
            if ($total !== null) {
                $used = (int)$up + (int)$down;
                $totalLeft = max(0, (int)$total - $used);
                $leftgb = round($totalLeft / 1073741824, 2);
            } else {
                $totalLeft = null;
                $leftgb = null;
            }

            // ===== پیام فوری: اتمام/غیرفعال/گذشتن زمان =====
            if ($notif == 0 && (
                ($leftgb !== null && $leftgb <= 0) ||
                ($expiryTimeSec !== null && $expiryTimeSec <= $now) ||
                (!$enable)
            )) {
                $msg = "💡 کاربر گرامی،
اشتراک «$remark» به پایان رسیده/غیرفعال شده است. می‌توانید از «خریدهای من» تمدید کنید یا سرویس جدید بخرید.";
                sendMessage($msg, null, null, $from_id);

                // دو روز بعد برای حذف زمان‌دار شود
                $newTime = $now + 2*86400;
                $stmt = $connection->prepare("UPDATE `orders_list` SET `notif`=? WHERE `uuid`=?");
                $stmt->bind_param("is", $newTime, $uuid);
                $stmt->execute();
                $stmt->close();
                continue;
            }

            // ===== هشدار نزدیک انقضا / کمتر از 1GB =====
            if ($notif == 0) {
                $shouldWarnTime = ($expiryTimeSec !== null && $expiryTimeSec < $now + 86400);
                $shouldWarnData = ($leftgb !== null && $leftgb < 1);
                if ($shouldWarnTime || $shouldWarnData) {
                    $unit = $shouldWarnTime ? "روز" : "گیگ";
                    $msg = "💡 کاربر گرامی،
از سرویس اشتراک $remark تنها (۱ $unit) باقی مانده است. می‌توانید از قسمت «خریدهای من» تمدید کنید یا سرویس جدید خریداری کنید.";
                    sendMessage($msg, null, null, $from_id);
                    // یک ساعت بعد دوباره بررسی؛ یا اگر انقضا نزدیک‌تر است، زودتر
                    $nextCheck = $now + 3600;
                    if ($expiryTimeSec !== null) $nextCheck = min($nextCheck, $expiryTimeSec);
                    $stmt = $connection->prepare("UPDATE `orders_list` SET `notif`=? WHERE `uuid`=?");
                    $stmt->bind_param("is", $nextCheck, $uuid);
                    $stmt->execute();
                    $stmt->close();
                    continue;
                }
            }

            // اگر اکانت disable بود ولی هنوز پیام فوری نرفت (مثلاً notif != 0)
            if (!$enable && $notif <= 0) {
                $newTime = $now + 2*86400;
                $stmt = $connection->prepare("UPDATE `orders_list` SET `notif`=? WHERE `uuid`=?");
                $stmt->bind_param("is", $newTime, $uuid);
                $stmt->execute();
                $stmt->close();
                continue;
            }
        }
    }
  }
}

// ====== LOOP 2: حذف نهایی بعد از موعد (notif > 0 و گذشته) ======
$stmt = $connection->prepare("SELECT * FROM `orders_list` WHERE `status`=1 AND `notif` > 0 AND `notif` < ? LIMIT 200");
$stmt->bind_param("i", $now);
$stmt->execute();
$orders = $stmt->get_result();
$stmt->close();

if ($orders && $orders->num_rows > 0) {
  while ($order = $orders->fetch_assoc()) {
    $from_id    = $order['userid'];
    $remark     = $order['remark'];
    $uuid       = $order['uuid'] ?? "0";
    $server_id  = (int)$order['server_id'];
    $inbound_id = (int)$order['inbound_id'];

    // حذف از پنل
    $res = null;
    $stmt = $connection->prepare("SELECT `type` FROM `server_config` WHERE `id`=?");
    $stmt->bind_param('i', $server_id);
    $stmt->execute();
    $rowConf = $stmt->get_result()->fetch_assoc();
    $stmt->close();
    $serverType = $rowConf['type'] ?? '';

    if ($serverType === "marzban") {
        $res = deleteMarzban($server_id, $remark);
    } else {
        if ($inbound_id > 0) $res = deleteClient($server_id, $inbound_id, $uuid, 1);
        else $res = deleteInbound($server_id, $uuid, 1);
    }

    if (!is_null($res)) {
        // پیام حذف
        $msg = "💡 کاربر گرامی،
اشتراک سرویس $remark منقضی شد و از لیست سفارش‌ها حذف گردید. لطفاً از فروشگاه سرویس جدید خریداری کنید.";
        sendMessage($msg, null, null, $from_id);

        // حذف از DB
        $stmt = $connection->prepare("DELETE FROM `orders_list` WHERE `uuid`=?");
        $stmt->bind_param("s", $uuid);
        $stmt->execute();
        $stmt->close();
    } else {
        // اگر حذف ناموفق بود، دوباره برای بررسی زمان‌دار شود
        $retry = $now + 6*3600;
        $stmt = $connection->prepare("UPDATE `orders_list` SET `notif`=? WHERE `uuid`=?");
        $stmt->bind_param("is", $retry, $uuid);
        $stmt->execute();
        $stmt->close();
    }
  }
}
